<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* themes/custom/notregrandblue/templates/content/paragraph/paragraph--block-cta--default.html.twig */
class __TwigTemplate_58fe969e68260a87fafa92bde918ede9 extends \Twig\Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->env->getExtension('\Twig\Extension\SandboxExtension');
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 41
        $context["classes"] = [0 => "paragraph", 1 => ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass($this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source,         // line 43
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 43), 43, $this->source))), 2 => ((        // line 44
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass($this->sandbox->ensureToStringAllowed(($context["view_mode"] ?? null), 44, $this->source)))) : ("")), 3 => (( !twig_get_attribute($this->env, $this->source,         // line 45
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 45)) ? ("paragraph--unpublished") : ("")), 4 => "simple-cta"];
        // line 48
        $this->displayBlock('paragraph', $context, $blocks);
    }

    public function block_paragraph($context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 49
        echo "  <section";
        echo $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, ($context["attributes"] ?? null), "addClass", [0 => ($context["classes"] ?? null)], "method", false, false, true, 49), 49, $this->source), "html", null, true);
        echo ">
    ";
        // line 50
        $this->displayBlock('content', $context, $blocks);
        // line 82
        echo "  </section>
";
    }

    // line 50
    public function block_content($context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 51
        echo "      <div class=\"container\">
        <div class=\"row\">
          ";
        // line 53
        if ((twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_position_image", [], "any", false, false, true, 53), 0, [], "any", false, false, true, 53), "value", [], "any", false, false, true, 53) == 0)) {
            // line 54
            echo "            <div class=\"col-lg-5 offset-lg-1\">
              <div class=\"left-image\">
                ";
            // line 56
            echo $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, ($context["content"] ?? null), "field_image", [], "any", false, false, true, 56), 0, [], "any", false, false, true, 56), 56, $this->source), "html", null, true);
            echo "
              </div>
            </div>
            <div class=\"col-lg-5 align-self-center\">
              ";
            // line 60
            echo $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, ($context["content"] ?? null), "field_body", [], "any", false, false, true, 60), 0, [], "any", false, false, true, 60), 60, $this->source), "html", null, true);
            echo "
              <div class=\"white-button\">
                ";
            // line 62
            echo $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, ($context["content"] ?? null), "field_link", [], "any", false, false, true, 62), 0, [], "any", false, false, true, 62), 62, $this->source), "html", null, true);
            echo "
              </div>
            </div>
          ";
        } else {
            // line 66
            echo "            <div class=\"col-lg-5 offset-lg-1 align-self-center\">
              ";
            // line 67
            echo $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, ($context["content"] ?? null), "field_body", [], "any", false, false, true, 67), 0, [], "any", false, false, true, 67), 67, $this->source), "html", null, true);
            echo "
              <div class=\"white-button\">
                ";
            // line 69
            echo $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, ($context["content"] ?? null), "field_link", [], "any", false, false, true, 69), 0, [], "any", false, false, true, 69), 69, $this->source), "html", null, true);
            echo "
              </div>
            </div>
            <div class=\"col-lg-5 offset-lg-1\">
              <div class=\"left-image\">
                ";
            // line 74
            echo $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, ($context["content"] ?? null), "field_image", [], "any", false, false, true, 74), 0, [], "any", false, false, true, 74), 74, $this->source), "html", null, true);
            echo "
              </div>
            </div>
          ";
        }
        // line 78
        echo "        </div>
      </div>

    ";
    }

    public function getTemplateName()
    {
        return "themes/custom/notregrandblue/templates/content/paragraph/paragraph--block-cta--default.html.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  121 => 78,  114 => 74,  106 => 69,  101 => 67,  98 => 66,  91 => 62,  86 => 60,  79 => 56,  75 => 54,  73 => 53,  69 => 51,  65 => 50,  60 => 82,  58 => 50,  53 => 49,  46 => 48,  44 => 45,  43 => 44,  42 => 43,  41 => 41,);
    }

    public function getSourceContext()
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}
{% set classes = [
  'paragraph',
  'paragraph--type--' ~ paragraph.bundle|clean_class,
  view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
  not paragraph.isPublished() ? 'paragraph--unpublished',
  'simple-cta'
] %}
{% block paragraph %}
  <section{{ attributes.addClass(classes) }}>
    {% block content %}
      <div class=\"container\">
        <div class=\"row\">
          {% if paragraph.field_position_image.0.value  == 0 %}
            <div class=\"col-lg-5 offset-lg-1\">
              <div class=\"left-image\">
                {{ content.field_image.0 }}
              </div>
            </div>
            <div class=\"col-lg-5 align-self-center\">
              {{ content.field_body.0 }}
              <div class=\"white-button\">
                {{ content.field_link.0 }}
              </div>
            </div>
          {% else %}
            <div class=\"col-lg-5 offset-lg-1 align-self-center\">
              {{ content.field_body.0 }}
              <div class=\"white-button\">
                {{ content.field_link.0 }}
              </div>
            </div>
            <div class=\"col-lg-5 offset-lg-1\">
              <div class=\"left-image\">
                {{ content.field_image.0 }}
              </div>
            </div>
          {% endif %}
        </div>
      </div>

    {% endblock %}
  </section>
{% endblock paragraph %}
", "themes/custom/notregrandblue/templates/content/paragraph/paragraph--block-cta--default.html.twig", "C:\\laragon\\www\\notregrandbleu\\web\\themes\\custom\\notregrandblue\\templates\\content\\paragraph\\paragraph--block-cta--default.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = array("set" => 41, "block" => 48, "if" => 53);
        static $filters = array("clean_class" => 43, "escape" => 49);
        static $functions = array();

        try {
            $this->sandbox->checkSecurity(
                ['set', 'block', 'if'],
                ['clean_class', 'escape'],
                []
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
